/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.report;

import com.quantumdata.fmteditor.MsgLog;
import com.quantumdata.fmteditor.report.FmtTable;
import com.quantumdata.fmteditor.report.FmtTableModel;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;

public class HtmlSummaryReport {
    private String m_fileName;
    private String m_srcName;
    private FmtTable m_table;

    public HtmlSummaryReport(String string, String string2, FmtTable fmtTable) {
        this.m_fileName = string2;
        this.m_table = fmtTable;
        this.m_srcName = string;
    }

    public void generateReport() {
        try {
            FileWriter fileWriter = new FileWriter(new File(this.m_fileName));
            this.writeHeader(fileWriter);
            this.startTable(fileWriter);
            this.writeRows(fileWriter);
            this.endTable(fileWriter);
            this.endDoc(fileWriter);
            fileWriter.close();
        }
        catch (IOException iOException) {
            String string = iOException.getMessage();
            if (string == null) {
                string = "Unkown File Error";
            }
            MsgLog.error(string);
        }
    }

    private void writeHeader(FileWriter fileWriter) throws IOException {
        fileWriter.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n");
        fileWriter.write("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
        fileWriter.write("<Head>\n");
        fileWriter.write("  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\" />\n");
        fileWriter.write("  <title>Quantum Data - Format List</title>\n");
        this.writeStyles(fileWriter);
        fileWriter.write("</HEAD>\n\n");
        fileWriter.write("<BODY bgcolor=\"#ffffff\" marginwidth=\"0\" marginheight=\"0\" leftmargin=\"0\" topmargin=\"15\" text=\"#666666\">\n");
        fileWriter.write("<center>\n");
        fileWriter.write("  <TABLE cellpadding=\"0\" cellspacing=\"0\" width=\"800\" border=\"0\">\n");
        fileWriter.write("  <TR><TD width=\"655\" class=\"header3\">Format Summary Report</TD></TR>\n");
        fileWriter.write("  <TR><TD width=\"400\" >");
        fileWriter.write(this.m_srcName);
        fileWriter.write("  </TD><TD width=\"400\" align=\"right\">");
        Date date = new Date();
        fileWriter.write(date.toString());
        fileWriter.write("</TD>\n");
        fileWriter.write("  </TR></TABLE><p></p>");
        fileWriter.write("</center><p>\n");
    }

    private void writeStyles(FileWriter fileWriter) throws IOException {
        fileWriter.write("  <style TYPE=\"text/css\">\n");
        fileWriter.write("  <!--\n");
        fileWriter.write(".header3 {\n");
        fileWriter.write("  font-family:helvitica, sans-serif;\n");
        fileWriter.write("  font-size:2.0em;\n");
        fileWriter.write("  color:#7A7778;\n");
        fileWriter.write("}\n");
        fileWriter.write("  -->\n");
        fileWriter.write("  </style>\n");
    }

    private void startTable(FileWriter fileWriter) throws IOException {
        fileWriter.write("<TABLE CELLSPACING=\"1\" CELLPADDING=\"1\" WIDTH=\"90%\" align=\"center\" border=\"1\">\n");
        fileWriter.write("  <TR>\n");
        FmtTableModel fmtTableModel = (FmtTableModel)this.m_table.getModel();
        int n = fmtTableModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            int n2 = this.m_table.convertColumnIndexToModel(i);
            fileWriter.write("    <TD BGCOLOR=\"#f1aa12\"><b>");
            fileWriter.write(fmtTableModel.getColumnName(n2));
            fileWriter.write("</b></TD>\n");
        }
        fileWriter.write("  </TR>\n");
    }

    private void writeRows(FileWriter fileWriter) throws IOException {
        FmtTableModel fmtTableModel = (FmtTableModel)this.m_table.getModel();
        int n = fmtTableModel.getRowCount();
        int n2 = fmtTableModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            fileWriter.write("  <TR>");
            for (int j = 0; j < n2; ++j) {
                fileWriter.write("    <TD>");
                fileWriter.write((String)fmtTableModel.getValueAt(i, this.m_table.convertColumnIndexToModel(j)));
                fileWriter.write("</TD>\n");
            }
            fileWriter.write("  </TR\n");
        }
    }

    private void endTable(FileWriter fileWriter) throws IOException {
        fileWriter.write("</TABLE></p>\n");
    }

    private void endDoc(FileWriter fileWriter) throws IOException {
        fileWriter.write("</BODY>\n");
    }
}

